<?php namespace Visiosoft\FranchModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;

class SectorController extends PublicController
{
    public function getSubSectors(SectorRepositoryInterface $sectorRepository)
    {
        try {
            if (!$sectorID = request()->sector_id) {
                throw new \Exception(trans('visiosoft.module.advs::message.the_sector_id_is_not_correct'));
            }

            return [
                'success' => true,
                'data' => $sectorRepository->findAllBy('parent_id', $sectorID),
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
        }
    }
}
