<?php namespace Visiosoft\FranchModule\Sector;

use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SectorRepository extends EntryRepository implements SectorRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SectorModel
     */
    protected $model;

    /**
     * Create a new SectorRepository instance.
     *
     * @param SectorModel $model
     */
    public function __construct(SectorModel $model)
    {
        $this->model = $model;
    }

    public function getSubSectors($parent_id = null)
    {
        $query = $this->newQuery();
        if (is_array($parent_id)) {
            $query = $query->whereIn('parent_id', $parent_id);
        } elseif ($parent_id) {
            $query = $query->where('parent_id', $parent_id);
        } else {
            $query = $query->where('parent_id', '!=', null);
        }
        return $query->get();
    }

    public function getParents()
    {
        return $this->newQuery()
            ->where('parent_id', null)
            ->get();
    }

}
