<?php namespace Visiosoft\FranchModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class FranchController extends PublicController
{
    protected $storeRepository;
    protected $categoryRepository;
    protected $sectorRepository;

    public function __construct(StoreRepositoryInterface $storeRepository, CategoryRepositoryInterface $categoryRepository,
                                SectorRepositoryInterface $sectorRepository)
    {
        $this->storeRepository = $storeRepository;
        $this->categoryRepository = $categoryRepository;
        $this->sectorRepository = $sectorRepository;
        parent::__construct();
    }

    public function brandForm()
    {
        return view('module::franchisor-brand-information-form');
    }

    public function PartnerForm()
    {
        return view('module::solution-partner-information-form');
    }

    public function listStores(Request $request)
    {
        $params = $request->toArray();

        $query = $this->storeRepository->searchStores($params, null, true);

        $sub_sectors = [];
        if ($request->has('main_sector')) {

            $main_sectors = $request->get('main_sector');

            $query = $query->where(function ($query) use ($main_sectors) {
                foreach ($main_sectors as $main_sector) {
                    $query = $query->orWhere('sector_id', $main_sector);
                }
            });

            //Get SubSectors
            $sub_sectors = $this->sectorRepository->getSubSectors($main_sectors)->pluck('name', 'id')->all();

            if ($request->has('sub_sector')) {
                $sub_sectors_params = $request->get('sub_sector');

                $query = $query->leftJoin('store_store_sub_sector', 'store_store.id','store_store_sub_sector.entry_id');

                $query = $query->where(function ($query) use ($sub_sectors_params) {
                    foreach ($sub_sectors_params as $sub_sector_param) {
                        $query = $query->orWhere('store_store_sub_sector.related_id', $sub_sector_param);
                    }
                });
            }
        }

        $stores = $query->orderBy('store_store.created_at', 'desc')->paginate(setting_value('streams::per_page'));

        $cats = $this->categoryRepository->mainCats();

        $hideLocationFilter = false;
        if (
            ($locationFilterCats = setting_value('visiosoft.module.store::hide_location_filter_categories'))
            && is_array($locationFilterCats)
            && count($locationFilterCats)
            && \request()->cat
        ) {
            $hideLocationFilter = in_array(\request()->cat, $locationFilterCats);
        }

        $filter_params = ['sub_sectors' => $sub_sectors];

        $compact = compact('stores', 'request', 'cats', 'hideLocationFilter', 'filter_params');

        Cookie::queue(Cookie::make('last_search', $request->getRequestUri(), 84000));

        $seoKeyword = setting_value('visiosoft.module.store::list_seo_keywords');
        if ($seoKeyword && count($seoKeyword)) {
            $this->template->set('meta_keywords', implode(', ', $seoKeyword));
        }

        return $this->view->make('visiosoft.module.store::list/list', $compact);
    }
}