<?php namespace Visiosoft\ForumModule\Mention;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Mention\Command\NotifyMentionedUser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

class MentionManager
{

    /**
     * Send a mention notification.
     *
     * @param UserInterface $user
     * @param DiscussionInterface $discussion
     * @param CommentInterface $comment
     */
    public function send(UserInterface $user, DiscussionInterface $discussion, CommentInterface $comment = null)
    {
        dispatch_now(new NotifyMentionedUser($user, $discussion, $comment));
    }
}
