<?php namespace Visiosoft\ForumModule\Discussion\Filter;

use Illuminate\Database\Eloquent\Builder;


class FilterFlagged
{

    /**
     * Handle the filter.
     *
     * @param Builder $query
     */
    public function handle(Builder $query)
    {
        $query
            ->select(['forum_discussions.*', 'forum_comments.created_by_id', 'forum_comments.flagged'])
            ->join('forum_comments', 'forum_comments.discussion_id', '=', 'forum_discussions.id')
            ->where('forum_comments.flagged', 1)
            ->orWhere('forum_discussions.flagged', 1)
            ->groupBy('forum_discussions.id');
    }
}
