<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

class UnlikeDiscussion
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * The user instance.
     *
     * @var UserInterface
     */
    protected $user;

    /**
     * Create a new UnlikeDiscussion instance.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     */
    public function __construct(DiscussionInterface $discussion, UserInterFace $user = null)
    {
        $this->user       = $user;
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param ParticipationRepositoryInterface $participation
     * @param Guard $auth
     * @return bool
     * @throws \Exception
     */
    public function handle(ReactionRepositoryInterface $reactions, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$this->user = $this->user ?: $auth->user()) {
            throw new \Exception('You must be logged in to unlike a comment.');
        }

        /* @var ReactionInterface|EloquentModel $reaction */
        if ($reaction = $reactions->findReaction('thumbsup', $this->discussion, $this->user)) {
            return (bool)$reactions->delete($reaction);
        }

        return true;
    }
}
