<?php namespace Visiosoft\ForumModule\Comment\Table;

use Visiosoft\ForumModule\Comment\Table\View\FlaggedQuery;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class CommentTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [
        'all',
        'flagged' => [
            'query' => FlaggedQuery::class,
        ],
        'trash',
    ];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'fields' => [
                'content',
            ],
        ],
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'user'    => [
            'wrapper'     => '
                {value.gravatar}
                <strong>{value.username}</strong>
                <br>
                {value.email}
                <br>
                <small class="text-muted">{value.created_at}</small>
                ',
            'value'       => [
                'gravatar'   => 'entry.created_by.gravatar.style("margin-right: 1rem; float: left;").width(70)',
                'created_at' => 'entry.createdAtDatetime()',
                'username'   => 'entry.created_by.username',
                'email'      => 'entry.created_by.email',
            ],
            'sort_column' => 'name',
            'attributes'  => [
                'style' => 'width: 400px;',
            ],
        ],
        'content' => [
            'value' => '{{ entry.content|markdown|mentions_linkify|str_linkify|emoji|str_truncate(100)|raw }}',
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit',
        'view' => [
            'target' => '_blank',
        ],
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete',
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'created_at' => 'DESC',
        ],
    ];
}
