<?php namespace Anomaly\ForumModule\Participation;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Class ParticipationRepository
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class ParticipationRepository extends EntryRepository implements ParticipationRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ParticipationModel
     */
    protected $model;

    /**
     * Create a new ParticipationRepository instance.
     *
     * @param ParticipationModel $model
     */
    public function __construct(ParticipationModel $model)
    {
        $this->model = $model;
    }

    /**
     * Find all participants by discussion.
     *
     * @param DiscussionInterface $discussion
     * @return ParticipationCollection
     */
    public function findAllByDiscussion(DiscussionInterface $discussion)
    {
        return $this->model->where('discussion_id', $discussion->getId())->get();
    }

    /**
     * Find a participant by discussion and user.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface $user
     * @return ParticipationInterface|null
     */
    public function findByDiscussionAndUser(DiscussionInterface $discussion, UserInterface $user)
    {
        return $this->model
            ->where('discussion_id', $discussion->getId())
            ->where('user_id', $user->getId())
            ->first();
    }
}
