<?php namespace Anomaly\ForumModule\Participation;

use Anomaly\ForumModule\Participation\Contract\ParticipationInterface;
use Anomaly\Streams\Platform\Model\Forum\ForumParticipationEntryModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Carbon\Carbon;

/**
 * Class ParticipationModel
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ParticipationModel extends ForumParticipationEntryModel implements ParticipationInterface
{

    /**
     * Get the user.
     *
     * @return UserInterface
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Get the related user ID.
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Get the read at datetime.
     *
     * @return Carbon
     */
    public function getReadAt()
    {
        return $this->read_at;
    }

    /**
     * return the read flag.
     *
     * @return bool
     */
    public function isRead()
    {
        return $this->getReadAt() !== null;
    }

    /**
     * return the liked flag.
     *
     * @return bool
     */
    public function isLiked()
    {
        return $this->liked;
    }

    /**
     * Return the following flag.
     *
     * @return bool
     */
    public function isFollowing()
    {
        return $this->following;
    }

}
