<?php namespace Anomaly\ForumModule\Participation\Contract;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Participation\ParticipationCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Interface ParticipationRepositoryInterface
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
interface ParticipationRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Find all participants by discussion.
     *
     * @param DiscussionInterface $discussion
     * @return ParticipationCollection
     */
    public function findAllByDiscussion(DiscussionInterface $discussion);

    /**
     * Find a participant by discussion and user.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface $user
     * @return ParticipationInterface|null
     */
    public function findByDiscussionAndUser(DiscussionInterface $discussion, UserInterface $user);
}
