<?php namespace Anomaly\ForumModule\Participation\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Carbon\Carbon;

/**
 * Interface ParticipationInterface
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
interface ParticipationInterface extends EntryInterface
{

    /**
     * Get the related user.
     *
     * @return UserInterface
     */
    public function getUser();

    /**
     * Get the related user ID.
     *
     * @return int
     */
    public function getUserId();

    /**
     * Get the read at datetime.
     *
     * @return Carbon
     */
    public function getReadAt();

    /**
     * Return the read flag.
     *
     * @return bool
     */
    public function isRead();

    /**
     * Return the liked flag.
     *
     * @return bool
     */
    public function isLiked();

    /**
     * Return the following flag.
     *
     * @return bool
     */
    public function isFollowing();

}
