<?php namespace Anomaly\ForumModule\Mention\Notification;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

/**
 * Class UserWasMentioned
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class UserWasMentioned extends Notification implements ShouldQueue
{

    use Queueable;

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new UserWasMentioned instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion, CommentInterface $comment = null)
    {
        $this->comment    = $comment;
        $this->discussion = $discussion;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  UserInterface $notifiable
     * @return array
     */
    public function via(UserInterface $notifiable)
    {
        return ['mail'];
    }

    /**
     * Return the mail message.
     *
     * @param  UserInterface $notifiable
     * @return MailMessage
     */
    public function toMail(UserInterface $notifiable)
    {
        $data = [
            'discussion' => $this->discussion->getTitle(),
            'username'   => $notifiable->getUsername(),
        ];

        return (new MailMessage())
            ->view('anomaly.module.forum::notifications.user_was_mentioned')
            ->subject(trans('anomaly.module.forum::notification.user_was_mentioned.subject', $data))
            ->line(trans('anomaly.module.forum::notification.user_was_mentioned.message', $data))
            ->action(
                trans('anomaly.module.forum::notification.user_was_mentioned.button', $data),
                url($this->discussion->route('view'))
            );
    }
}
