<?php namespace Anomaly\ForumModule\Mention;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Mention\Command\NotifyMentionedUser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Class MentionManager
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class MentionManager
{

    /**
     * Send a mention notification.
     *
     * @param UserInterface $user
     * @param DiscussionInterface $discussion
     * @param CommentInterface $comment
     */
    public function send(UserInterface $user, DiscussionInterface $discussion, CommentInterface $comment = null)
    {
        dispatch_now(new NotifyMentionedUser($user, $discussion, $comment));
    }
}
