<?php namespace Anomaly\ForumModule\Mention\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Mention\Contract\MentionInterface;
use Anomaly\ForumModule\Mention\Notification\UserWasMentioned;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notifiable;
use Illuminate\Queue\InteractsWithQueue;

/**
 * Class NotifyMentionedUser
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class NotifyMentionedUser implements ShouldQueue
{

    use InteractsWithQueue;

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * The user instance.
     *
     * @var UserInterface|Notifiable
     */
    protected $user;

    /**
     * Create a new NotifyMentionedUser instance.
     *
     * @param UserInterface|Notifiable $user
     * @param DiscussionInterface $discussion
     * @param CommentInterface $comment
     */
    public function __construct(UserInterface $user, DiscussionInterface $discussion, CommentInterface $comment = null)
    {
        $this->discussion = $discussion;
        $this->comment    = $comment;
        $this->user       = $user;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        $this->user->notify(new UserWasMentioned($this->discussion, $this->comment));
    }
}
