<?php namespace Anomaly\ForumModule\Http\Controller;

use Anomaly\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Contracts\Routing\ResponseFactory;

/**
 * Class RssController
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class RssController extends PublicController
{

    /**
     * Return an RSS feed of recent discussions.
     *
     * @param  DiscussionRepositoryInterface $discussions
     * @param  ResponseFactory $response
     * @return \Illuminate\Http\Response|ResponseFactory
     */
    public function recent(DiscussionRepositoryInterface $discussions, ResponseFactory $response)
    {
        $response = $response
            ->view(
                'anomaly.module.forum::discussions/rss',
                [
                    'discussions' => $discussions->getRecent($this->request->get('limit')),
                ]
            )
            ->setTtl(3600);

        $response->headers->set('content-type', 'text/xml');

        return $response;
    }

    /**
     * Return an RSS feed of recent discussions by channel.
     *
     * @param DiscussionRepositoryInterface $discussions
     * @param ChannelRepositoryInterface $channels
     * @param ResponseFactory $response
     * @param $channel
     * @return $this|ResponseFactory
     */
    public function channel(
        DiscussionRepositoryInterface $discussions,
        ChannelRepositoryInterface $channels,
        ResponseFactory $response,
        $channel
    ) {
        if (!$channel = $channels->findBySlug($channel)) {
            abort(404);
        }

        $response = $response
            ->view(
                'anomaly.module.forum::discussions/rss',
                [
                    'discussions' => $discussions->findManyByChannel($channel, $this->request->get('limit')),
                ]
            )
            ->setTtl(3600);

        $response->headers->set('content-type', 'text/xml');

        return $response;
    }

}
