<?php namespace Anomaly\ForumModule\Http\Controller;

use Anomaly\ForumModule\Flag\Contract\FlagInterface;
use Anomaly\ForumModule\Flag\Contract\FlagRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class FlagsController
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class FlagsController extends PublicController
{

    /**
     * Delete a flag.
     *
     * @param FlagRepositoryInterface $comments
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete(FlagRepositoryInterface $comments, $id)
    {
        /* @var FlagInterface|EloquentModel $flag */
        if (!$flag = $comments->find($id)) {
            abort(404);
        }

        $comments->delete($flag);

        return $this->redirect->back();
    }

}
