<?php namespace Anomaly\ForumModule\Http\Controller\Admin;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\ForumModule\Discussion\Form\DiscussionFormBuilder;
use Anomaly\ForumModule\Discussion\Table\DiscussionTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

/**
 * Class DiscussionsController
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param  DiscussionTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DiscussionTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param  DiscussionFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DiscussionFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param  DiscussionFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DiscussionFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Redirect to a discussion.
     *
     * @param  DiscussionRepositoryInterface $discussions
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function view(DiscussionRepositoryInterface $discussions, $id)
    {
        /* @var DiscussionInterface $discussion */
        $discussion = $discussions->find($id);

        return $this->redirect->to($discussion->route('view'));
    }
}
