<?php namespace Anomaly\ForumModule\Http\Controller\Admin;

use Anomaly\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\ForumModule\Channel\Form\ChannelFormBuilder;
use Anomaly\ForumModule\Channel\Table\ChannelTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

/**
 * Class ChannelsController
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param  ChannelTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ChannelTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param  ChannelFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ChannelFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param  ChannelFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ChannelFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Redirect to a channel page.
     *
     * @param  ChannelRepositoryInterface $channels
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function view(ChannelRepositoryInterface $channels, $id)
    {
        /* @var ChannelInterface $channel */
        $channel = $channels->find($id);

        return $this->redirect->to($channel->route('view'));
    }
}
