<?php namespace Anomaly\ForumModule;

use Anomaly\ForumModule\Channel\ChannelModel;
use Anomaly\ForumModule\Channel\ChannelRepository;
use Anomaly\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\ForumModule\Comment\CommentModel;
use Anomaly\ForumModule\Comment\CommentRepository;
use Anomaly\ForumModule\Comment\Contract\CommentRepositoryInterface;
use Anomaly\ForumModule\Comment\Form\CommentFormBuilder;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\ForumModule\Discussion\DiscussionModel;
use Anomaly\ForumModule\Discussion\DiscussionRepository;
use Anomaly\ForumModule\Discussion\Form\DiscussionFormBuilder;
use Anomaly\ForumModule\Http\Controller\Admin\AssignmentsController;
use Anomaly\ForumModule\Http\Controller\Admin\FieldsController;
use Anomaly\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\ForumModule\Participation\ParticipationModel;
use Anomaly\ForumModule\Participation\ParticipationRepository;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Assignment\AssignmentRouter;
use Anomaly\Streams\Platform\Field\FieldRouter;
use Anomaly\Streams\Platform\Model\Forum\ForumChannelsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumCommentsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumDiscussionsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumParticipationEntryModel;

/**
 * Class ForumModuleServiceProvider
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class ForumModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon bindings.
     *
     * @var array
     */
    protected $bindings = [
        'forms::forum.comments'             => CommentFormBuilder::class,
        'forms::forum.discussions'          => DiscussionFormBuilder::class,
        ForumParticipationEntryModel::class => ParticipationModel::class,
        ForumDiscussionsEntryModel::class   => DiscussionModel::class,
        ForumChannelsEntryModel::class      => ChannelModel::class,
        ForumCommentsEntryModel::class      => CommentModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @var array
     */
    protected $singletons = [
        ParticipationRepositoryInterface::class => ParticipationRepository::class,
        DiscussionRepositoryInterface::class    => DiscussionRepository::class,
        ChannelRepositoryInterface::class       => ChannelRepository::class,
        CommentRepositoryInterface::class       => CommentRepository::class,
    ];

    /**
     * The addon routes.
     *
     * @var array
     */
    protected $routes = [
        'forum/rss.xml'                                       => [
            'as'   => 'anomaly.module.posts::posts.rss',
            'uses' => 'Anomaly\ForumModule\Http\Controller\RssController@recent',
        ],
        'forum/rss/channels/{channel}.xml'                    => [
            'as'   => 'anomaly.module.forum::channels.rss',
            'uses' => 'Anomaly\ForumModule\Http\Controller\RssController@channel',
        ],
        'forum'                                               => [
            'as'   => 'anomaly.module.forum::discussions.index',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@index',
        ],
        'forum/discussions/create'                            => [
            'as'                               => 'anomaly.module.forum::discussions.create',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.write',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@create',
        ],
        'forum/discussions/{id}/edit'                         => [
            'as'                               => 'anomaly.module.forum::discussions.edit',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.write',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@edit',
        ],
        'forum/discussions/{id}/delete'                       => [
            'as'                               => 'anomaly.module.forum::discussions.delete',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.delete',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@delete',
        ],
        'forum/discussions/{id}/lock'                         => [
            'as'                               => 'anomaly.module.forum::discussions.lock',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.lock',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@lock',
        ],
        'forum/discussions/{id}/unlock'                       => [
            'as'                               => 'anomaly.module.forum::discussions.unlock',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.lock',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@unlock',
        ],
        'forum/discussions/{id}/pin'                          => [
            'as'                               => 'anomaly.module.forum::discussions.pin',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.pin',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@pin',
        ],
        'forum/discussions/{id}/unpin'                        => [
            'as'                               => 'anomaly.module.forum::discussions.unpin',
            'anomaly.module.users::permission' => 'anomaly.module.forum::discussions.pin',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@unpin',
        ],
        'forum/discussions/{id}/follow'                       => [
            'as'   => 'anomaly.module.forum::discussions.follow',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@follow',
        ],
        'forum/discussions/{id}/unfollow'                     => [
            'as'   => 'anomaly.module.forum::discussions.unfollow',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@unfollow',
        ],
        'forum/discussions/{id}/flag'                         => [
            'as'                               => 'anomaly.module.forum::discussions.flag',
            'anomaly.module.users::permission' => 'anomaly.module.forum::flags.write',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@flag',
        ],
        'forum/discussions/{id}/unflag'                       => [
            'as'                               => 'anomaly.module.forum::discussions.unflag',
            'anomaly.module.users::permission' => 'anomaly.module.forum::flags.delete',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@unflag',
        ],
        'forum/discussions/{id}/like'                         => [
            'as'   => 'anomaly.module.forum::discussions.like',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@like',
        ],
        'forum/discussions/{id}/unlike'                       => [
            'as'   => 'anomaly.module.forum::discussions.unlike',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@unlike',
        ],
        'forum/comments/{id}/edit'                            => [
            'as'                               => 'anomaly.module.forum::comments.edit',
            'anomaly.module.users::permission' => 'anomaly.module.forum::comments.write',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\CommentsController@edit',
        ],
        'forum/comments/{id}/flag'                            => [
            'as'                               => 'anomaly.module.forum::comments.flag',
            'anomaly.module.users::permission' => 'anomaly.module.forum::flags.write',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\CommentsController@flag',
        ],
        'forum/comments/{id}/unflag'                          => [
            'as'                               => 'anomaly.module.forum::comments.unflag',
            'anomaly.module.users::permission' => 'anomaly.module.forum::flags.delete',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\CommentsController@unflag',
        ],
        'forum/channels/{channel}/{slug}'                     => [
            'as'   => 'anomaly.module.forum::discussions.view',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@view',
        ],
        'forum/channels/{channel}/{discussion}#comment-{id}' => [
            'as'   => 'anomaly.module.forum::comments.view',
            'uses' => 'Anomaly\ForumModule\Http\Controller\DiscussionsController@view',
        ],
        'forum/channels/{slug}'                               => [
            'as'   => 'anomaly.module.forum::channels.view',
            'uses' => 'Anomaly\ForumModule\Http\Controller\ChannelsController@view',
        ],
        'forum/comments/{id}/delete'                          => [
            'as'                               => 'anomaly.module.forum::comments.delete',
            'anomaly.module.users::permission' => 'anomaly.module.forum::comments.delete',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\CommentsController@delete',
        ],
        'forum/flags/{id}/delete'                             => [
            'as'                               => 'anomaly.module.forum::flags.delete',
            'anomaly.module.users::permission' => 'anomaly.module.forum::flags.delete',
            'uses'                             => 'Anomaly\ForumModule\Http\Controller\FlagsController@unflag',
        ],
        'forum/comments/{id}/answer'                          => [
            'as'   => 'anomaly.module.forum::comments.answer',
            'uses' => 'Anomaly\ForumModule\Http\Controller\CommentsController@answer',
        ],
        'forum/comments/{id}/like'                            => [
            'as'   => 'anomaly.module.forum::comments.like',
            'uses' => 'Anomaly\ForumModule\Http\Controller\CommentsController@like',
        ],
        'forum/comments/{id}/unlike'                          => [
            'as'   => 'anomaly.module.forum::comments.unlike',
            'uses' => 'Anomaly\ForumModule\Http\Controller\CommentsController@unlike',
        ],

        'admin/forum'                    => 'Anomaly\ForumModule\Http\Controller\Admin\DiscussionsController@index',
        'admin/forum/create'             => 'Anomaly\ForumModule\Http\Controller\Admin\DiscussionsController@create',
        'admin/forum/edit/{id}'          => 'Anomaly\ForumModule\Http\Controller\Admin\DiscussionsController@edit',
        'admin/forum/view/{id}'          => 'Anomaly\ForumModule\Http\Controller\Admin\DiscussionsController@view',
        'admin/forum/comments'           => 'Anomaly\ForumModule\Http\Controller\Admin\CommentsController@index',
        'admin/forum/comments/create'    => 'Anomaly\ForumModule\Http\Controller\Admin\CommentsController@create',
        'admin/forum/comments/edit/{id}' => 'Anomaly\ForumModule\Http\Controller\Admin\CommentsController@edit',
        'admin/forum/comments/view/{id}' => 'Anomaly\ForumModule\Http\Controller\Admin\CommentsController@view',
        'admin/forum/channels'           => 'Anomaly\ForumModule\Http\Controller\Admin\ChannelsController@index',
        'admin/forum/channels/create'    => 'Anomaly\ForumModule\Http\Controller\Admin\ChannelsController@create',
        'admin/forum/channels/edit/{id}' => 'Anomaly\ForumModule\Http\Controller\Admin\ChannelsController@edit',
        'admin/forum/channels/view/{id}' => 'Anomaly\ForumModule\Http\Controller\Admin\ChannelsController@view',
    ];

    /**
     * Map the addon.
     *
     * @param  FieldRouter $fields
     * @param  AssignmentRouter $assignments
     */
    public function map(FieldRouter $fields, AssignmentRouter $assignments)
    {
        $fields->route($this->addon, FieldsController::class);

        $assignments->route(
            $this->addon,
            AssignmentsController::class,
            'admin/forum'
        );
    }

}
