<?php namespace Anomaly\ForumModule\Discussion\Notification;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\AnonymousNotifiable;
use Illuminate\Notifications\Notification;

/**
 * Class DiscussionWasCreated
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionWasCreated extends Notification implements ShouldQueue
{

    use Queueable;

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new DiscussionWasCreated instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion, CommentInterface $comment = null)
    {
        $this->comment    = $comment;
        $this->discussion = $discussion;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param AnonymousNotifiable $notifiable
     * @return array
     */
    public function via(AnonymousNotifiable $notifiable)
    {
        return ['mail'];
    }

    /**
     * Return the mail message.
     *
     * @param  AnonymousNotifiable $notifiable
     * @return MailMessage
     */
    public function toMail(AnonymousNotifiable $notifiable)
    {
        $data = [
            'discussion' => $this->discussion->getTitle(),
            'username'   => $this->discussion->getAuthorUsername(),
        ];

        return (new MailMessage())
            ->view('anomaly.module.forum::notifications.discussion_was_created')
            ->greeting($data['discussion'])
            ->subject(trans('anomaly.module.forum::notification.discussion_was_created.subject', $data))
            ->line(trans('anomaly.module.forum::notification.discussion_was_created.message', $data))
            ->action(
                trans('anomaly.module.forum::notification.discussion_was_created.button', $data),
                url($this->discussion->route('view'))
            );
    }
}
