<?php namespace Anomaly\ForumModule\Discussion\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

/**
 * Class DiscussionFormBuilder
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionFormBuilder extends FormBuilder
{

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [
        'slug',
        'author',
        'ip_address',
        'flagged',
        'flagged_by',
        'answer',
        'locked',
        'locked_by',
        'pinned',
        'pinned_by',
    ];

    protected $fields = [
        'channel' => [
            'config' => [
                'default_value' => '{request.input.channel}',
            ],
        ],
        'title',
        'content',
    ];

    /**
     * The form actions.
     *
     * @var array
     */
    protected $actions = [
        'submit',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'success_message' => false,
    ];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'anomaly.module.forum::css/jquery.atwho.min.css',
        ],
        'scripts.js' => [
            'anomaly.module.forum::js/jquery.caret.min.js',
            'anomaly.module.forum::js/jquery.atwho.min.js',
            'anomaly.module.forum::js/mention.js',
        ],
    ];
}
