<?php namespace Anomaly\ForumModule\Discussion\Filter;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class FilterTrending
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class FilterTrending
{

    /**
     * Handle the filter.
     *
     * @param Builder $query
     */
    public function handle(Builder $query)
    {
        $query->orderBy('view_count', 'DESC');
        $query->whereDate('created_at', '>', Carbon::make('-1 week'));
    }
}
