<?php namespace Anomaly\ForumModule\Discussion\Filter;

use Illuminate\Contracts\Auth\Guard;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class FilterParticipating
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class FilterParticipating
{

    /**
     * Handle the filter.
     *
     * @param Builder $query
     * @param Guard $auth
     */
    public function handle(Builder $query, Guard $auth)
    {
        $query
            ->select(['forum_discussions.*', 'forum_participation.user_id'])
            ->join('forum_participation', 'forum_participation.discussion_id', '=', 'forum_discussions.id')
            ->where('forum_participation.user_id', $auth->id());
    }
}
