<?php namespace Anomaly\ForumModule\Discussion\Filter;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class FilterNoReplies
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class FilterNoReplies
{

    /**
     * Handle the filter.
     *
     * @param Builder $query
     */
    public function handle(Builder $query)
    {
        $query->where(
            function (Builder $query) {
                $query->whereNull('comment_count');
                $query->orWhere('comment_count', '<', 1);
            }
        );
    }
}
