<?php namespace Anomaly\ForumModule\Discussion\Event;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;

/**
 * Class DiscussionWasCreated
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionWasCreated
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new DiscussionWasCreated instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Get the discussion.
     *
     * @return DiscussionInterface
     */
    public function getDiscussion()
    {
        return $this->discussion;
    }
}
