<?php namespace Anomaly\ForumModule\Discussion;

use Anomaly\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

/**
 * Class DiscussionRepository
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionRepository extends EntryRepository implements DiscussionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DiscussionModel
     */
    protected $model;

    /**
     * Create a new DiscussionRepository instance.
     *
     * @param DiscussionModel $model
     */
    public function __construct(DiscussionModel $model)
    {
        $this->model = $model;
    }

    /**
     * Get recent discussions.
     *
     * @return DiscussionCollection
     */
    public function getRecent($limit = null)
    {
        return $this->model
            ->orderBy('created_at', 'DESC')
            ->take($limit)
            ->get();
    }

    /**
     * Find a discussion by slug.
     *
     * @param $slug
     * @return DiscussionInterface
     */
    public function findBySlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }

    /**
     * Find many discussions by channel.
     *
     * @param ChannelInterface $channel
     * @param $limit
     * @return DiscussionCollection
     */
    public function findManyByChannel(ChannelInterface $channel, $limit)
    {
        return $this->model
            ->where('channel_id', $channel->getId())
            ->take($limit)
            ->get();
    }
}
