<?php namespace Anomaly\ForumModule\Discussion;

use Anomaly\ForumModule\Discussion\Command\FollowDiscussion;
use Anomaly\ForumModule\Discussion\Command\SendNotifications;
use Anomaly\ForumModule\Discussion\Command\SetIpAddress;
use Anomaly\ForumModule\Discussion\Command\SetUniqueSlug;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Notification\DiscussionWasCreated;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;

/**
 * Class DiscussionObserver
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionObserver extends EntryObserver
{

    /**
     * Fired before creating an entry.
     *
     * @param DiscussionInterface|EntryInterface $entry
     */
    public function creating(EntryInterface $entry)
    {
        dispatch_now(new SetIpAddress($entry));
        dispatch_now(new SetUniqueSlug($entry));

        parent::creating($entry);
    }

    /**
     * Run after a record is created.
     *
     * @param DiscussionInterface|EntryInterface $entry
     */
    public function created(EntryInterface $entry)
    {
        dispatch_now(new FollowDiscussion($entry, $entry->getCreatedBy()));

        dispatch_now(new SendNotifications($entry));

        event(new DiscussionWasCreated($entry));

        parent::created($entry);
    }
}
