<?php namespace Anomaly\ForumModule\Discussion;

use Anomaly\ForumModule\Discussion\Command\FlagDiscussion;
use Anomaly\ForumModule\Discussion\Command\FollowDiscussion;
use Anomaly\ForumModule\Discussion\Command\LikeDiscussion;
use Anomaly\ForumModule\Discussion\Command\UnflagDiscussion;
use Anomaly\ForumModule\Discussion\Command\UnfollowDiscussion;
use Anomaly\ForumModule\Discussion\Command\UnlikeDiscussion;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Class DiscussionManager
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionManager
{

    /**
     * Flag a discussion.
     *
     * @param DiscussionInterface $discussion
     * @return bool
     */
    public function flag(DiscussionInterface $discussion)
    {
        return dispatch_now(new FlagDiscussion($discussion));
    }

    /**
     * Unflag a discussion.
     *
     * @param DiscussionInterface $discussion
     * @return bool
     */
    public function unflag(DiscussionInterface $discussion)
    {
        return dispatch_now(new UnflagDiscussion($discussion));
    }

    /**
     * Follow a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function follow(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new FollowDiscussion($discussion, $user));
    }

    /**
     * Unfollow a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function unfollow(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new UnfollowDiscussion($discussion, $user));
    }

    /**
     * Like a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function like(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new LikeDiscussion($discussion, $user));
    }

    /**
     * Unlike a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function unlike(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new UnlikeDiscussion($discussion, $user));
    }
}
