<?php namespace Anomaly\ForumModule\Discussion;

use Anomaly\Streams\Platform\Entry\EntryCriteria;

/**
 * Class DiscussionCriteria
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DiscussionCriteria extends EntryCriteria
{

    /**
     * Filter discussions.
     *
     * @param $filter
     * @return $this
     */
    public function filter($filter)
    {
        if ($query = config('anomaly.module.forum::forum.filters.' . $filter . '.query')) {
            app()->call($query, ['query' => $this->query], 'handle');
        }

        return $this;
    }
}
