<?php namespace Anomaly\ForumModule\Discussion\Contract;

use Anomaly\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\ForumModule\Discussion\DiscussionCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

/**
 * Interface DiscussionRepositoryInterface
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
interface DiscussionRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Get recent discussions.
     *
     * @return DiscussionCollection
     */
    public function getRecent($limit = null);

    /**
     * Find a discussion by slug.
     *
     * @param $slug
     * @return DiscussionInterface
     */
    public function findBySlug($slug);

    /**
     * Find many discussions by channel.
     *
     * @param ChannelInterface $channel
     * @param $limit
     * @return DiscussionCollection
     */
    public function findManyByChannel(ChannelInterface $channel, $limit);
}
