<?php namespace Anomaly\ForumModule\Discussion\Contract;

use Anomaly\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\ForumModule\Comment\CommentCollection;
use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationInterface;
use Anomaly\ForumModule\Participation\ParticipationCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

/**
 * Interface DiscussionInterface
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
interface DiscussionInterface extends EntryInterface
{

    /**
     * Return the read flag.
     *
     * @return bool
     */
    public function isRead();

    /**
     * Return the liked flag.
     *
     * @return bool
     */
    public function isLiked();

    /**
     * Return the following flag.
     *
     * @return bool
     */
    public function isFollowing();

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getSlug();

    /**
     * Get the title.
     *
     * @return string
     */
    public function getTitle();

    /**
     * Get the view count.
     *
     * @return int
     */
    public function getViewCount();

    /**
     * Get the comment count.
     *
     * @return int
     */
    public function getCommentCount();

    /**
     * Get the content.
     *
     * @return string
     */
    public function getContent();

    /**
     * Get the related channel.
     *
     * @return ChannelInterface
     */
    public function getChannel();

    /**
     * Get the related channel slug.
     *
     * @return string
     */
    public function getChannelSlug();

    /**
     * Return the answered flag.
     *
     * @return bool
     */
    public function isAnswered();

    /**
     * Get the related answer.
     *
     * @return CommentInterface
     */
    public function getAnswer();

    /**
     * Get the related comments.
     *
     * @return CommentCollection
     */
    public function getComments();

    /**
     * Get the last related comment.
     *
     * @return CommentInterface|null
     */
    public function getLastComment();

    /**
     * Return the comments relation.
     *
     * @return HasMany
     */
    public function comments();

    /**
     * Get the related participation.
     *
     * @return ParticipationInterface
     */
    public function getParticipation();

    /**
     * Return the participation relation.
     *
     * @return HasOne
     */
    public function participation();

    /**
     * Get the related participants.
     *
     * @return ParticipationCollection
     */
    public function getParticipants();

    /**
     * Return the participants relation.
     *
     * @return HasMany
     */
    public function participants();

    /**
     * Return the flagged flag.
     *
     * @return bool
     */
    public function isFlagged();

    /**
     * Return the approved flag.
     *
     * @return bool
     */
    public function isApproved();

    /**
     * Return the pinned flag.
     *
     * @return bool
     */
    public function isPinned();

    /**
     * Get the related followers.
     *
     * @return ParticipationCollection
     */
    public function getFollowers();

    /**
     * Return the followers relation.
     *
     * @return HasOne
     */
    public function followers();

    /**
     * Get the author's username.
     *
     * @return string
     */
    public function getAuthorUsername();

}
