<?php namespace Anomaly\ForumModule\Discussion\Command;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Illuminate\Http\Request;

/**
 * Class SetIpAddress
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class SetIpAddress
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new SetIpAddress instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param Request $request
     */
    public function handle(Request $request)
    {
        $this->discussion->setAttribute('ip_address', $request->getClientIp());
    }
}
