<?php namespace Anomaly\ForumModule\Discussion\Command;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

/**
 * Class LikeDiscussion
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class LikeDiscussion
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * The user instance.
     *
     * @var UserInterface
     */
    protected $user;

    /**
     * Create a new LikeDiscussion instance.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     */
    public function __construct(DiscussionInterface $discussion, UserInterFace $user = null)
    {
        $this->user       = $user;
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param ReactionRepositoryInterface $reactions
     * @param Guard $auth
     * @return bool
     * @throws \Exception
     */
    public function handle(ReactionRepositoryInterface $reactions, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$this->user = $this->user ?: $auth->user()) {
            throw new \Exception('You must be logged in to like a comment.');
        }

        /* @var ReactionInterface|EloquentModel $reaction */
        if (!$reaction = $reactions->findReaction('thumbsup', $this->discussion, $this->user)) {
            return (bool)$reactions->create(
                [
                    'subject' => $this->discussion,
                    'user'    => $this->user,
                    'type'    => 'thumbsup',
                ]
            );
        }

        return true;
    }
}
