<?php namespace Anomaly\ForumModule\Discussion\Command;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class IncrementViewCount
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class IncrementViewCount
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface|EloquentModel
     */
    protected $discussion;

    /**
     * Create a new SetMetaInformation instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {
        $discussions->withoutEvents(function() use ($discussions) {
            $discussions->save($this->discussion->setAttribute('view_count', $this->discussion->getViewCount() + 1));
        });
    }
}
