<?php namespace Anomaly\ForumModule\Discussion\Command;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Mention\Contract\MentionRepositoryInterface;
use Anomaly\ForumModule\Mention\MentionManager;
use Anomaly\ForumModule\Mention\MentionParser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Notifications\Notifiable;

/**
 * Class HandleMentions
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class HandleMentions
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new SetApproval instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param MentionParser $parser
     * @param UserRepositoryInterface $users
     */
    public function handle(
        UserRepositoryInterface $users,
        MentionManager $mentions,
        MentionParser $parser
    ) {
        foreach ($parser->parse($this->discussion->getContent()) as $mention) {

            /* @var Notifiable|UserInterface $user */
            if (!$user = $users->findByUsername($mention)) {
                continue;
            }

            $mentions->send($user, $this->discussion);
        }
    }
}
