<?php namespace Anomaly\ForumModule\Discussion\Command;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Contracts\Auth\Guard;

/**
 * Class FlagDiscussion
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class FlagDiscussion
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface|EloquentModel
     */
    protected $discussion;

    /**
     * Create a new FlagDiscussion instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param Guard $auth
     * @param DiscussionRepositoryInterface $discussions
     * @return bool
     * @throws \Exception
     */
    public function handle(Guard $auth, DiscussionRepositoryInterface $discussions)
    {
        if (!$user = $auth->user()) {
            throw new \Exception('You must be logged in to flag a discussion.');
        }

        $this->discussion->setAttribute('flagged', true);
        $this->discussion->setAttribute('flagged_by', $user);

        return $discussions->save($this->discussion);
    }
}
