<?php namespace Anomaly\ForumModule\Comment\Form;

use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

/**
 * Class CommentFormBuilder
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class CommentFormBuilder extends FormBuilder
{

    /**
     * The discussion instance.
     *
     * @var null|DiscussionInterface
     */
    protected $discussion = null;

    /**
     * The form fields.
     *
     * @var array
     */
    protected $fields = [
        'content' => [
            'label' => 'anomaly.module.forum::field.comment.label',
        ],
        '*',
    ];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [
        'flagged',
        'flagged_by',
        'discussion',
        'ip_address',
        'approved',
    ];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'submit' => [
            'text' => 'anomaly.module.forum::message.post_reply',
        ],
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'success_message' => false,
    ];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'anomaly.module.forum::css/jquery.atwho.min.css',
        ],
        'scripts.js' => [
            'anomaly.module.forum::js/jquery.caret.min.js',
            'anomaly.module.forum::js/jquery.atwho.min.js',
            'anomaly.module.forum::js/mention.js',
        ],
    ];

    /**
     * Fired just before saving.
     */
    public function onSaving()
    {
        if (!$discussion = $this->getDiscussion()) {
            return;
        }

        $comment = $this->getFormEntry();

        $comment->setAttribute('discussion', $discussion);
        $comment->setAttribute('approved', true); // @todo Follow up with approval strategies
    }

    /**
     * Get the discussion.
     *
     * @return DiscussionInterface|null
     */
    public function getDiscussion()
    {
        return $this->discussion;
    }

    /**
     * Set the discussion.
     *
     * @param  DiscussionInterface $discussion
     * @return $this
     */
    public function setDiscussion(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;

        return $this;
    }
}
