<?php namespace Anomaly\ForumModule\Comment;

use Anomaly\ForumModule\Comment\Command\DecrementCommentCount;
use Anomaly\ForumModule\Comment\Command\IncrementCommentCount;
use Anomaly\ForumModule\Comment\Command\NotifyMentions;
use Anomaly\ForumModule\Comment\Command\SetIpAddress;
use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Participation\Command\NotifyFollowers;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;

/**
 * Class CommentObserver
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class CommentObserver extends EntryObserver
{

    /**
     * Fired just before creating an entry.
     *
     * @param EntryInterface|CommentInterface $entry
     */
    public function creating(EntryInterface $entry)
    {
        dispatch_now(new SetIpAddress($entry));

        parent::creating($entry);
    }

    /**
     * Fired just after creating an entry.
     *
     * @param EntryInterface|CommentInterface $entry
     */
    public function created(EntryInterface $entry)
    {
        dispatch_now(new IncrementCommentCount($entry));

        dispatch_now(new NotifyMentions($entry)); // Do this before.
        dispatch_now(new NotifyFollowers($entry)); // Do this after.

        parent::created($entry);
    }

    /**
     * Fired just after deleting an entry.
     *
     * @param EntryInterface|CommentInterface $entry
     */
    public function deleted(EntryInterface $entry)
    {
        dispatch_now(new DecrementCommentCount($entry));

        parent::deleted($entry);
    }

}
