<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Illuminate\Http\Request;

/**
 * Class SetIpAddress
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class SetIpAddress
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetIpAddress instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param Request $request
     */
    public function handle(Request $request)
    {
        $this->comment->setAttribute('ip_address', $request->getClientIp());
    }
}
