<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Mention\MentionManager;
use Anomaly\ForumModule\Mention\MentionParser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Notifications\Notifiable;

/**
 * Class NotifyMentions
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class NotifyMentions
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetApproval instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param MentionParser $parser
     * @param MentionManager $manager
     * @param UserRepositoryInterface $users
     */
    public function handle(
        MentionParser $parser,
        MentionManager $manager,
        UserRepositoryInterface $users
    ) {
        foreach ($parser->parse($this->comment->getContent()) as $mention) {

            /* @var Notifiable|UserInterface $user */
            if (!$user = $users->findByUsername($mention)) {
                continue;
            }

            $manager->send($user, $this->comment->getDiscussion(), $this->comment);
        }
    }
}
