<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

/**
 * Class LikeComment
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class LikeComment
{

    /**
     * The comment interface.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * The user instance.
     *
     * @var UserInterface
     */
    protected $user;

    /**
     * Create a new LikeComment instance.
     *
     * @param CommentInterface $comment
     * @param UserInterface|null $user
     */
    public function __construct(CommentInterface $comment, UserInterFace $user = null)
    {
        $this->user    = $user;
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param ReactionRepositoryInterface $reactions
     * @param Guard $auth
     * @return bool
     * @throws \Exception
     */
    public function handle(ReactionRepositoryInterface $reactions, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$this->user = $this->user ?: $auth->user()) {
            throw new \Exception('You must be logged in to like a comment.');
        }

        /* @var ReactionInterface|EloquentModel $reaction */
        if (!$reaction = $reactions->findReaction('thumbsup', $this->comment, $this->user)) {
            return (bool)$reactions->create(
                [
                    'subject' => $this->comment,
                    'user'    => $this->user,
                    'type'    => 'thumbsup',
                ]
            );
        }

        return true;
    }
}
