<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class IncrementCommentCount
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class IncrementCommentCount
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetApproval instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {
        /* @var DiscussionInterface|EloquentModel $discussion */
        $discussion = $this->comment->getDiscussion();

        $discussions->withoutEvents(
            function () use ($discussion, $discussions) {
                $discussions->save($discussion->setAttribute('comment_count', $discussion->getCommentCount() + 1));
            }
        );
    }
}
