<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Comment\Contract\CommentRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Contracts\Auth\Guard;

/**
 * Class FlagComment
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class FlagComment
{

    /**
     * The comment instance.
     *
     * @var CommentInterface|EloquentModel
     */
    protected $comment;

    /**
     * Create a new FlagComment instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param Guard $auth
     * @param CommentRepositoryInterface $comments
     * @return bool
     * @throws \Exception
     */
    public function handle(Guard $auth, CommentRepositoryInterface $comments)
    {
        if (!$user = $auth->user()) {
            throw new \Exception('You must be logged in to flag a comment.');
        }

        $this->comment->setAttribute('flagged', true);
        $this->comment->setAttribute('flagged_by', $user);

        return $comments->save($this->comment);
    }
}
