<?php namespace Anomaly\ForumModule\Comment\Command;

use Anomaly\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class DecrementCommentCount
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class DecrementCommentCount
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetApproval instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {
        if (!$this->comment->isForceDeleting()) {
            return;
        }

        /* @var DiscussionInterface|EloquentModel $discussion */
        $discussion = $this->comment->getDiscussion();

        $discussions->save($discussion->setAttribute('comment_count', $discussion->getCommentCount() - 1));
    }
}
