<?php namespace Anomaly\ForumModule\Channel\Form;

/**
 * Class ChannelFormSections
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelFormSections
{

    /**
     * Handle the command.
     *
     * @param ChannelFormBuilder $builder
     */
    public function handle(ChannelFormBuilder $builder)
    {
        $stream = $builder->getFormStream();

        $builder->setSections(
            [
                'locked'   => [
                    'fields' => $stream
                        ->getAssignments()
                        ->locked()
                        ->fieldSlugs(),
                ],
                'unlocked' => [
                    'fields' => $stream
                        ->getAssignments()
                        ->unlocked()
                        ->fieldSlugs(),
                ],
            ]
        );
    }
}
