<?php namespace Anomaly\ForumModule\Channel\Contract;

use Anomaly\ForumModule\Discussion\DiscussionCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\Role\RoleCollection;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Interface ChannelInterface
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
interface ChannelInterface extends EntryInterface
{

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getSlug();

    /**
     * Get the name.
     *
     * @return string
     */
    public function getName();

    /**
     * Get the description.
     *
     * @return string
     */
    public function getDescription();

    /**
     * Get the related discussions.
     *
     * @return DiscussionCollection
     */
    public function getDiscussions();

    /**
     * Return the discussions relation.
     *
     * @return HasMany
     */
    public function discussions();

    /**
     * Get the allowed roles.
     *
     * @return RoleCollection
     */
    public function getAllowedRoles();
}
