<?php namespace Anomaly\ForumModule\Channel;

use Anomaly\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\ForumModule\Discussion\DiscussionCollection;
use Anomaly\ForumModule\Discussion\DiscussionModel;
use Anomaly\Streams\Platform\Model\Forum\ForumChannelsEntryModel;
use Anomaly\UsersModule\Role\RoleCollection;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

/**
 * Class ChannelModel
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelModel extends ForumChannelsEntryModel implements ChannelInterface
{

    /**
     * The cascaded relations.
     *
     * @var array
     */
    protected $cascades = [
        'discussions',
    ];

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Get the name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the related discussions.
     *
     * @return DiscussionCollection
     */
    public function getDiscussions()
    {
        return $this->discussions;
    }

    /**
     * Return the discussions relation.
     *
     * @return HasMany
     */
    public function discussions()
    {
        return $this->hasMany(DiscussionModel::class, 'channel_id');
    }

    /**
     * Get the allowed roles.
     *
     * @return RoleCollection
     */
    public function getAllowedRoles()
    {
        return $this->allowed_roles;
    }

}
