<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Forum Blacklist
    |--------------------------------------------------------------------------
    |
    | Define blacklisted terms to be applied
    | to discussions and comments alike.
    */

    'blacklist' => array_filter(explode(',', env('FORUM_BLACKLIST'))),

    /*
    |--------------------------------------------------------------------------
    | Filters
    |--------------------------------------------------------------------------
    |
    | Specify available filters for the forum.
    */

    'filters' => [
        'mine'          => [
            'user'  => true,
            'title' => 'anomaly.module.forum::filter.mine',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterMine::class,
        ],
        'participating' => [
            'user'  => true,
            'title' => 'anomaly.module.forum::filter.participating',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterParticipating::class,
        ],
        'following'     => [
            'title' => 'anomaly.module.forum::filter.following',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterFollowing::class,
        ],
        'trending'      => [
            'title' => 'anomaly.module.forum::filter.trending',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterTrending::class,
        ],
        'popular'       => [
            'title' => 'anomaly.module.forum::filter.popular',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterPopular::class,
        ],
        'answered'      => [
            'title' => 'anomaly.module.forum::filter.answered',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterAnswered::class,
        ],
        'unanswered'    => [
            'title' => 'anomaly.module.forum::filter.unanswered',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterUnanswered::class,
        ],
        'no_replies'    => [
            'title' => 'anomaly.module.forum::filter.no_replies',
            'query' => \Anomaly\ForumModule\Discussion\Filter\FilterNoReplies::class,
        ],
        'flagged'       => [
            'title'      => 'anomaly.module.forum::filter.flagged',
            'permission' => 'anomaly.module.forum::*.flag',
            'query'      => \Anomaly\ForumModule\Discussion\Filter\FilterFlagged::class,
        ],
    ],

];
