<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

/**
 * Class AnomalyModuleForumCreateFollowersStream
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class AnomalyModuleForumCreateFollowersStream extends Migration
{

    /**
     * Delete this stream when resetting.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'followers',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subject' => [
            'required' => true,
        ],
        'user'    => [
            'required' => true,
        ],
    ];

}
