<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

/**
 * Class AnomalyModuleForumCreateParticipationStream
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class AnomalyModuleForumCreateParticipationStream extends Migration
{

    /**
     * Delete this stream when resetting.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'participation',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'discussion' => [
            'required' => true,
        ],
        'user'       => [
            'required' => true,
        ],
        'following',
        'read_at',
        'liked',
    ];
}
